package gov.va.med.mhv.mrp.web.controller;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import javax.annotation.PostConstruct;
import javax.faces.application.FacesMessage;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.ManagedProperty;
import javax.faces.bean.RequestScoped;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.portlet.PortletRequest;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import gov.va.med.mhv.mrp.common.dto.MyGoalDTO;
import gov.va.med.mhv.mrp.common.dto.MyGoalTaskDTO;
import gov.va.med.mhv.mrp.common.dto.MyGoalsExtensionDTO;
import gov.va.med.mhv.mrp.enums.GoalCompletionTypeEnumeration;
import gov.va.med.mhv.mrp.enums.GoalPriorityTypeEnumeration;
import gov.va.med.mhv.mrp.enums.GoalStatusTypeEnumeration;
import gov.va.med.mhv.mrp.web.bean.GoalSamples;
import gov.va.med.mhv.mrp.web.bean.UserProfile;
import gov.va.med.mhv.mrp.web.converter.MyGoalConverter;
import gov.va.med.mhv.mrp.web.converter.MyGoalDTOConverter;
import gov.va.med.mhv.mrp.web.converter.MyGoalTaskDTOConverter;
import gov.va.med.mhv.mrp.web.model.MyGoal;
import gov.va.med.mhv.mrp.web.model.MyGoalTask;
import gov.va.med.mhv.mrp.web.model.MyGoalsExtension;
import gov.va.med.mhv.mrp.webservice.MyGoalsWebService;

@ManagedBean
@RequestScoped
public class GoalSamplesController implements Serializable {
	private static final long serialVersionUID = 1L;
	private static Logger log = LogManager.getLogger(GoalSamplesController.class);
	
	@ManagedProperty("#{myGoalsWebServiceProxy}")
	private MyGoalsWebService myGoalsWebServiceProxy;

	@ManagedProperty("#{myGoalConverter}")
	private MyGoalConverter myGoalConverter;
	
	@ManagedProperty("#{goalSamples}")
	private GoalSamples goalSamples;

	@ManagedProperty("#{param.goalId}")
	private Long goalId;
	
	@ManagedProperty("#{myGoalDTOConverter}")
	private MyGoalDTOConverter myGoalDTOConverter;
	
	@ManagedProperty("#{myGoalTaskDTOConverter}")
	private MyGoalTaskDTOConverter myGoalTaskDTOConverter;
	
	@ManagedProperty("#{userProfile}")
	private UserProfile userProfile;

	private MyGoal goal;

	@PostConstruct
	public void postConstruct() {
		log.debug("@PostConstruct");

		if (goalId != null) {
			int id = goalId.intValue();
			if (id >= 0 && id < goalSamples.getSamples().size()) {
				goal = goalSamples.getSamples().get(id);
			}
		}

		if (goal == null) {
			try {
				FacesContext.getCurrentInstance().getExternalContext().redirect("my-goals");
			} catch (IOException e) {
				log.debug(e);
			}
		}

		log.debug(this);
	}
	
	public void selectAll() {
		Boolean checked = true;

		// if any field is checked, check them all
		// otherwise default is uncheck

		log.debug("selectAll");
		
		if (goal == null) {
			return;
		}

		for (MyGoalsExtension ext : goal.getMyGoalsExtensions()) {
			checked = checked && ext.getSelected();
			for (MyGoalTask task : ext.getTasks()) {
				checked = checked && task.getSelected();
			}
		}
		
		if (checked) {
			checked = false;
		} else {
			checked = true;
		}
		
		for (MyGoalsExtension ext : goal.getMyGoalsExtensions()) {
			ext.setSelected(checked);
			for (MyGoalTask task : ext.getTasks()) {
				task.setSelected(checked);
			}
		}
		
		log.debug("done");
	}

	public GoalSamples getGoalSamples() {
		return goalSamples;
	}

	public void setGoalSamples(GoalSamples goalSamples) {
		this.goalSamples = goalSamples;
	}

	public MyGoal getGoal() {
		return goal;
	}

	public Long getGoalId() {
		return goalId;
	}

	public void setGoalId(Long goalId) {
		this.goalId = goalId;
	}

	@Override
	public String toString() {
		return "GoalSamplesController [goalId=" + goalId + "]";
	}
	
	public String save() {
		log.debug(":: save ::");
		
		saveGoal();
		
		return "/views/trackgoals/viewgoal?faces-redirect=true&goalId=" + goalId;
		
	}

	private Boolean saveGoal() {
        Boolean success = false;

        log.debug(this);

        for (Iterator<MyGoalsExtension> iter = goal.getMyGoalsExtensions()
        		.iterator(); iter.hasNext();) {
        	MyGoalsExtension ext = iter.next();

        	boolean extChecked = ext.getSelected() && ext.getSelected() != null;

        	for (Iterator<MyGoalTask> goalTaskIter = ext.getTasks()
        			.iterator(); goalTaskIter.hasNext();) {
        		MyGoalTask myGoalTask = goalTaskIter.next();

        		boolean taskChecked = myGoalTask.getSelected();
        		if (!taskChecked) {
        			goalTaskIter.remove();
        		}

        	}

        	if (!extChecked) {
        		iter.remove();
        	}


        }



        try {
        	log.debug("Converting to DTO");
        	MyGoalDTO myGoalDTO = myGoalDTOConverter.convert(goal);


        	// set defaults for new record
        	if (myGoalDTO.getGoalId() == null) {

        		log.debug("creating new");
        		myGoalDTO.setUserProfileId(userProfile.getUserProfileId());
        		myGoalDTO.setStartDate(new Date());
        		myGoalDTO.setOplock(0);
        		myGoalDTO.setCompletionType(GoalCompletionTypeEnumeration.NOENDDATE.getCode());
        		myGoalDTO.setPriorityType(GoalPriorityTypeEnumeration.OTHER.getCode());
        		myGoalDTO.setStatus(GoalStatusTypeEnumeration.NOTCOMPLETE.getCode());
        	}

        	if (myGoalDTO.getCompletionType() == GoalCompletionTypeEnumeration.NOENDDATE.getCode()) {
        		myGoalDTO.setEndDate(null);
        	}

        	log.debug("before save");

        	MyGoalDTO resultDTO = myGoalsWebServiceProxy.saveMyGoal(myGoalDTO.getUserProfileId(), myGoalDTO);

        	log.debug("after save");

        	goalId = resultDTO.getGoalId();

        	if (resultDTO != null) {
        		if (log.isDebugEnabled()) {
        			log.debug("return from save" + resultDTO);
        		}

        		goal = myGoalConverter.convert(resultDTO);

        		success = true;
        	}

        } catch (Exception e) {
        	log.error(e);
        }

        if (!success) {
        	log.debug("Save failed");
        	FacesContext.getCurrentInstance().addMessage("", new FacesMessage(FacesMessage.SEVERITY_ERROR, "save failed", "save failed"));
        }

		
		return success;
	}

	public MyGoalsWebService getMyGoalsWebServiceProxy() {
		return myGoalsWebServiceProxy;
	}

	public void setMyGoalsWebServiceProxy(MyGoalsWebService myGoalsWebServiceProxy) {
		this.myGoalsWebServiceProxy = myGoalsWebServiceProxy;
	}

	public MyGoalConverter getMyGoalConverter() {
		return myGoalConverter;
	}

	public void setMyGoalConverter(MyGoalConverter myGoalConverter) {
		this.myGoalConverter = myGoalConverter;
	}

	public MyGoalDTOConverter getMyGoalDTOConverter() {
		return myGoalDTOConverter;
	}

	public void setMyGoalDTOConverter(MyGoalDTOConverter myGoalDTOConverter) {
		this.myGoalDTOConverter = myGoalDTOConverter;
	}

	public MyGoalTaskDTOConverter getMyGoalTaskDTOConverter() {
		return myGoalTaskDTOConverter;
	}

	public void setMyGoalTaskDTOConverter(
			MyGoalTaskDTOConverter myGoalTaskDTOConverter) {
		this.myGoalTaskDTOConverter = myGoalTaskDTOConverter;
	}

	public UserProfile getUserProfile() {
		return userProfile;
	}

	public void setUserProfile(UserProfile userProfile) {
		this.userProfile = userProfile;
	}

	public void setGoal(MyGoal goal) {
		this.goal = goal;
	}


}
